package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;
import net.minecraft.entity.CloneCraftEntityAccessor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;

public class GeneFireProof extends Gene{

	public GeneFireProof(int id) {
		super(id);
	}
	
	@Override
	public String getName() {
		return "Fire-Proof";
	}

	@Override
	public int getMaxAmount() {
		return 1;
	}

	@Override
	public String getStringValue(int amount) {
		return "Fire Proof";
	}

	@Override
	public int getColour() {
		return 0xff53aaba;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntityPigZombie.class, EntityMagmaCube.class, EntityGhast.class, EntityBlaze.class};
	}

	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		CloneCraftEntityAccessor.setIsImmuneToFire(entity, true);
	}

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
	}

}
